/**
* \file: libtestbedapp_intern.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: application-framework
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef LIBTESTBEDAPP_SRC_LIBTESTBEDAPP_INTERN_H_
#define LIBTESTBEDAPP_SRC_LIBTESTBEDAPP_INTERN_H_

#include <stdarg.h>

#define LOG_MESSAGE_MAX 1024

void libtestbedapp_log(const char *prefix, int prefix_len, tba_loglevel_t msg_log_level,
		const char *message, ...) __attribute__ ((format (printf, 4, 5)));

#define log_debug(...) libtestbedapp_log("DEBUG: ",7, TBA_LOGLEVEL_DEBUG, __VA_ARGS__)

#define log_info(...) libtestbedapp_log("INFO: ",6, TBA_LOGLEVEL_INFO, __VA_ARGS__)

#define log_error(...) libtestbedapp_log("ERROR: ",7, TBA_LOGLEVEL_ERROR, __VA_ARGS__)

#endif /* LIBTESTBEDAPP_INTERN_H_ */
